
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <time.h>

#define MAP_SIZE ( 32 )
#define MAP_BLANK_SIZE ( 3 )
#define ROUTE_STEP ( 100 ) ///< X^[gS[܂ł̓̂
#define USER_HP ( 1000 )

enum MoveAngle
{
    MoveAngle_Up,
    MoveAngle_Down,
    MoveAngle_Left,
    MoveAngle_Right,
    MoveAngle_Num
};

struct Pos
{
    int x , y;
};

//-----User W[ start
struct UserInfo
{
    struct Pos pos;
    int floor;
    int hp;
};

static void UserInfo_Init( struct UserInfo* user_info )
{
    user_info->pos.x = 0;
    user_info->pos.y = 0;
    user_info->floor = 1;
    user_info->hp = USER_HP;
}
//-----User W[ end

//-----Map W[ start
struct Map
{
    char data[ MAP_SIZE ][ MAP_SIZE ];
    struct Pos start;
    struct Pos goal;
};

static void Map_Init( struct Map* map )
{
    memset( map->data , '#' , MAP_SIZE * MAP_SIZE );
    map->start.x = 0;
    map->start.y = 0;
    map->goal.x = 0;
    map->goal.y = 0;
}

static void Map_Draw( struct Map* map , struct UserInfo* user_info )
{
    int i , j;
    
    for( i = user_info->pos.y - MAP_BLANK_SIZE; i <= user_info->pos.y + MAP_BLANK_SIZE; i++)
    {
        for( j = user_info->pos.x - MAP_BLANK_SIZE; j <= user_info->pos.x + MAP_BLANK_SIZE; j++)
        {
            if( i == user_info->pos.y && j == user_info->pos.x )
            {
                printf( "@" );
            }
            else
            {
                printf( "%c" , map->data[i][j]);
            }
        }
        printf("\n");
    }
    
    
    /*
    //}bvŜ\
    for( i = 0; i < MAP_SIZE; i++)
    {
        for( j = 0; j < MAP_SIZE; j++)
        {
            printf( "%c" , map->data[i][j]);
        }
        printf("\n");
    }
    */
}

static int map_start_and_end_pos_make( int size )
{
    return rand() % ( size - 4 ) + 2;
}

static bool set_next_pos( struct Pos* pos , struct Pos* start_pos, int map_size )
{
    //Őiޕ̗Dxo
    int rand_ans = 0;
    int priority[4] = { 0 };
    int priority_sum = 0;
    priority[0] = ( start_pos->x * 10000 ) / map_size;
    priority[1] = 10000 - priority[0];
    priority[2] = ( start_pos->y * 10000 ) / map_size;
    priority[3] = 10000 - priority[2];
    
    priority_sum = priority[0] + priority[1] + priority[2] + priority[3];
    
    rand_ans = rand() % priority_sum;
    
    if( rand_ans < priority[0] )
    {//LEFT
        if( pos->x - 1 <= MAP_BLANK_SIZE ) return false;
        pos->x--;
    }
    else if( rand_ans < priority[0] + priority[1] )
    {//RIGHT
        if( pos->x + 1 > map_size - MAP_BLANK_SIZE - 1 ) return false;
        pos->x++;
    }
    else if( rand_ans < priority[0] + priority[1] + priority[2] )
    {//UP
        if( pos->y - 1 <= MAP_BLANK_SIZE ) return false;
        pos->y--;
    }
    else
    {//DOWN
        if( pos->y + 1 > map_size - MAP_BLANK_SIZE - 1 ) return false;
        pos->y++;
    }
    
    return true;
}

static struct Pos make_route( struct Map* map , int map_size , int rpute_step , bool is_start_goal_set )
{
    int i;
    static Pos work;
    
    map->start.x = map_start_and_end_pos_make( map_size );
    map->start.y = map_start_and_end_pos_make( map_size );
    
    work.x = map->start.x;
    work.y = map->start.y;
    
    for( i = 0; i < rpute_step; i++)
    {
        while( set_next_pos( &work , &map->start , map_size ) == false );
        map->data[ work.y ][ work.x ] = ' ';
    }
    
    map->goal.x = work.x;
    map->goal.y = work.y;
    
    if( is_start_goal_set )
    {
        map->data[ map->goal.y ][ map->goal.x ] = 'G';
        map->data[ map->start.y ][ map->start.x ] = 'S';
    }
    
    return map->start;
}

static void random_chip_set( struct Map* map , int map_size )
{
    int i,j;
    for( i = MAP_BLANK_SIZE; i < map_size - MAP_BLANK_SIZE; i++)
    {
        for( j = MAP_BLANK_SIZE; j < map_size - MAP_BLANK_SIZE; j++)
        {
            map->data[i][j] = ( ( rand() % 100 ) < 50 ) ? ' ' : '#';
        }
    }
}

static struct Pos Map_Make( struct Map* map )
{
    int i;
    for( i = 0; i < 10; i++)
    {
        make_route( map , MAP_SIZE , 30 , false);
    }
    random_chip_set( map , MAP_SIZE );
    
    return make_route( map , MAP_SIZE , 100  , true);
}

//-----Map W[ end

static void DrawProc( struct Map* map , struct UserInfo* user_info )
{
    if( user_info->hp > 0 )
    {
        Map_Draw( map , user_info);
    
        printf( "--------------------\n" );
        printf( "Floor: %d\n" , user_info->floor );
        printf( "HP: %d\n" , user_info->hp );
        printf( "--------------------\n" );
        printf( "[W]: UP\n" );
        printf( "[S]: DOWN\n" );
        printf( "[A]: LEFT\n" );
        printf( "[D]: RIGHT\n" );
        printf( "[\\]:Game End\n" );
    }
    else
    {
        printf( "--------------------\n" );
        printf( " Game Over \n" );
        printf( " Your score is %d. \n" , user_info->floor );
        printf( "--------------------\n" );
        printf( "[\\]: Game End\n" );
    }
}

static bool MoveProc( struct Map* map , struct UserInfo* user_info , char key )
{
    switch( key )
    {
    case 'w':
        if( map->data[ user_info->pos.y-1 ][ user_info->pos.x ] != '#')
        {
            user_info->pos.y--;
            user_info->hp--;
        }
        break;
    case 's':
        if( map->data[ user_info->pos.y+1 ][ user_info->pos.x ] != '#')
        {
            user_info->pos.y++;
            user_info->hp--;
        }
        break;
    case 'a':
        if( map->data[ user_info->pos.y ][ user_info->pos.x-1 ] != '#')
        {
            user_info->pos.x--;
            user_info->hp--;
        }
        break;
    case 'd':
        if( map->data[ user_info->pos.y ][ user_info->pos.x+1 ] != '#')
        {
            user_info->pos.x++;
            user_info->hp--;
        }
        break;
    }
    
    if( map->data[ user_info->pos.y ][ user_info->pos.x ] == 'G') return true;
    
    return false;
}

int main()
{
    char key = 0;
    struct Map map;
    struct UserInfo user_info;
    
    srand( (unsigned)time( NULL ) );
    
    Map_Init( &map );
    UserInfo_Init( &user_info );
    user_info.pos = Map_Make( &map );
    
    while( key != '\\' )
    {
        if( user_info.hp > 0 )
        {
            if( MoveProc( &map , &user_info , key ) )
            {
                Map_Init( &map );
                user_info.pos = Map_Make( &map );
                user_info.floor++;
            }
        }
        DrawProc( &map , &user_info );
        
        key = getch();
        system( "cls" );
    }
    
    return 0;
}


